// ccf2efc.cpp  Some parts Copyright 2000 John S. Fine
//
// I found the source code for LISTCCF on remotecentral.com
// It didn't have a Copyright notice or author's name.  I
// don't know if the uploader is the author.  I don't know
// what uses of the source code the author intended to permit.
// I added some of my own source code, resulting in this
// program.
//
// This is an interim test copy.  Please use it only for
// testing the decode routines.  Please discard by July 30,2000
// I hope to have a better version with more specific release
// rights before that.

#include "stdafx.h"
#include <string.h>

char mem[512*1024];		// space for the ccf file
int endmem;

FILE * ftxt;

char * buttonname[7] = 
{ "Left","Right","Vol-","Vol+","Chan-","Chan+","Mute" };
char * fontname[8] = 
{ "<none>","Pronto 8","Pronto 10","Pronto 12","Pronto 14","Pronto 16","Pronto 18","Pronto 20" };


bool readccf(char * fn);
void property(int p, char *, bool);
void panel(int p);
void item(int p);
void macro(int p);
void ircode(int p);
void frame(int p);
void button(int p);
void printstring(int p);
int getnum(int p, int l);

///////////////////////////////////////////////////////////////////////
// Declarations for Decode routines by John S. Fine
//
typedef union {
	unsigned char b[8];
	unsigned long d[2];
	unsigned long l;
	} BITBUFFER;

typedef struct {
				  // General information about the whole decode being attempted
	FILE *ftxt;   // Output file
	float *ffp;   // Whole list of fp values
	float freq;   // Frequency
	int once;     // Number of pairs in the send-once portion
	int again;    // Number of pairs in the repeat section

	              // Information for one attempt at one part of the above
	int count;    // Number of pairs
	float *fp;    // Pointer to this part
	float *pulses;// Sorted array of pulses
	float *gaps;  // Sorted list of gaps
	float Total;
	BITBUFFER bufr; // Buffer for accumulating bit decodes
	int ones;
	int istats[8];
	float fstats[8];
	float unit;
	int last;

} INFO;
//
// These are each intended to return a confidence level from zero, meaning
// nothing was displayed, up to 100, meaning the input was a good clean
// example of this encoding.
//
void decoder(INFO &in);

int TrySONY(INFO &in);
int TryNEC(INFO &in);
int TryRCA(INFO &in);
int TryRC(INFO &in);
int TryJVC(INFO &in);
int TryS16a(INFO &in);
int TryOldPanasonic(INFO &in);
int TryS42(INFO &in);
int TrySHARP(INFO &in);
int TryPANASONIC(INFO &in);
int TryJerrold(INFO &in);
int TryFurby(INFO &in);
int TryX10IR(INFO &in);
//
// Internal decode routines used as helpers for the above
//
int TryPANASONIC1(float *fp, char *which, FILE *ftxt);
//
// Utility routines used by the above
float median(float *fp, int count);
void pwm(INFO *in, float *fp, int count, float cutoff, int phase);
void pwm2(INFO *in, float *fp, int count, float cutoff);
int obc2efc(int obc);
unsigned long reverse(unsigned long val);
//
///////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////
// Declarations for DLL Decode routines by Daniel Arnold
//
typedef void (CALLBACK* typeDecodeIR) (unsigned int* Context,
		const int* TpaiBursts, 	
		const int TiFreq, 
		const int TiSingleBurstCount, 
		const int TiRepeatBurstCount, 
		char* TsProtocol, 
		int* TiDevice, 
		int* TiSubDevice, 
		int* TiOBC, 
		int TaiHex[4], 
		char* TsMisc, 
		char* TsError);

typedef int (CALLBACK* typeProtocolSupportLevel) (char * TsProtocol);

int TryDLL(INFO &in);
int HexCmdToEFC(int iHexCmd);
void LoadDll();
int ProtocolSupportLevel(char *Protocol);

HINSTANCE hDll = NULL;
typeDecodeIR lpfnDecodeIR;
typeProtocolSupportLevel lpfnProtocolSupportLevel;

//
///////////////////////////////////////////////////////////////////////

int main(int argc, char* argv[])
{
	// open the ccf and list files
	
	char fn1[256];
	char fn2[256];

	if (argc!=2) {
		fprintf(stderr,"use: listccf filename\n");
		return 1;
	}
	strcpy(fn1,argv[1]);
	char * p = strrchr(fn1,'.');
	if (p==NULL)
		strcat(fn1,".ccf");

	strcpy(fn2,argv[1]);
	p = strrchr(fn2,'.');
	if (p!=NULL)
		*p = 0;
	strcat(fn2,".txt");
	
	ftxt = fopen(fn2,"w");

	
	//Load the DecodeIR dll
	LoadDll();

	// read the ccf file and process it
	if (readccf(fn1)) {
		// Home pages pointer
		if (getnum(0x0030,4)) {
			property(getnum(0x0030,4),"HOME",true);
		}
		// Device pages pointer
		if (getnum(0x0034,4)) {
			property(getnum(0x0034,4),"DEVICE",true);
		}
		// Macro pages pointer
		if (getnum(0x0038,4)) {
			property(getnum(0x0038,4),"MACRO",false);
		}
	}
	fprintf(ftxt,"\n");
	fclose(ftxt);

	//Unload the DecodeIR dll if it was loaded
	if (hDll != 0)
		FreeLibrary(hDll);

	return 0;
}

// read a ccf file, up to 512k bytes

bool readccf(char * fn)
{
    FILE *st = fopen(fn,"rb");
	if (st == NULL) 
		return false;
	endmem = fread( (void *)mem, 1, 512*1024, st);
	fclose(st);
	return true;
}

// process a linked set of devices, macros or the home page
// each with a property section and a list of panels

void property(int p, char * name, bool lrbuttons)
{
	while (p) {
		fprintf(ftxt,"\n\n%s(%08X) ",name,p); printstring(getnum(p+0x0004,4));
//		if (getnum(p+0x0008,4)) // Home icon
//			fprintf(ftxt,"\n\tHome icon(%08X)",getnum(p+0x0008,4));
//		if (getnum(p+0x000C,4)) // ?
//			fprintf(ftxt,"\n\t000C: %08X",getnum(p+0x000C,4));
		if (getnum(p+0x0010,4)) { // Action
			if (mem[getnum(p+0x0010,4)]) {
				fprintf(ftxt,"\n\tAction "); 
				macro(getnum(p+0x0010,4));
			}
		}
		if (lrbuttons && getnum(p+0x0014,4)) { // Left button, except in macro
			if (mem[getnum(p+0x0014,4)]) {
				fprintf(ftxt,"\n\tLeft  ");
				printstring(getnum(p+0x0034,4)); 
				macro(getnum(p+0x0014,4));
			}
		}
		if (lrbuttons && getnum(p+0x0018,4)) { // Right button, except in macro
			if (mem[getnum(p+0x0018,4)]) {
				fprintf(ftxt,"\n\tRight  ");
				printstring(getnum(p+0x0038,4)); 
				macro(getnum(p+0x0018,4));
			}
		}
		if (getnum(p+0x001C,4)) { // vol -
			if (mem[getnum(p+0x001C,4)]) {
				fprintf(ftxt,"\n\tVol-  "); 
				macro(getnum(p+0x001C,4));
			}
		}
		if (getnum(p+0x0020,4)) { // vol +
			if (mem[getnum(p+0x0020,4)]) {
				fprintf(ftxt,"\n\tVol+  "); 
				macro(getnum(p+0x0020,4));
			}
		}
		if (getnum(p+0x0024,4)) { // chan -
			if (mem[getnum(p+0x0024,4)]) {
				fprintf(ftxt,"\n\tChan- "); 
				macro(getnum(p+0x0024,4));
			}
		}
		if (getnum(p+0x0028,4)) { // chan +
			if (mem[getnum(p+0x0028,4)]) {
				fprintf(ftxt,"\n\tChan+ "); 
				macro(getnum(p+0x0028,4));
			}
		}
		if (getnum(p+0x002C,4)) { // mute
			if (mem[getnum(p+0x002C,4)]) {
				fprintf(ftxt,"\n\tMute "); 
				macro(getnum(p+0x002C,4));
			}
		}
//		if (getnum(p+0x0030,4)) { // ?
//			fprintf(ftxt,"\n\t0030: %08X",getnum(p+0x0030,4));
//		}

		// panels of device
		int address = getnum(p+0x003C,4);
		if (address)
			panel(address);

		// link to next device
		p=getnum(p+0x0000,4);
	}
}

// a linked list of panels, with up to 255 buttons or frames

void panel(int p)
{
	while(p) {
		fprintf(ftxt,"\npanel "); printstring(getnum(p+4,4));
		int items = getnum(p+8,1);
//		fprintf(ftxt," %d",items);
		int address = p+10;
		while(items--) {
			item(address);
			address = address +9;
		}
		// link to next panel
		p = getnum(p,4);
	}
}

// process a list of buttons or frames on a panel or in a frame

void item(int p)
{
	if (mem[p+8]==0) {
		// frame
//		fprintf(ftxt,"\n\tFrame(%08X)=%d,%d",getnum(p+4,4),getnum(p,2),getnum(p+2,2));
		frame(getnum(p+4,4));
	}
	else if (mem[p+8]==1) {
		// button
//		fprintf(ftxt,"\n\tButton(%08X)=%d,%d",buttonaddr,getnum(p,2),getnum(p+2,2));
		button(getnum(p+4,4));
	}
	else {
		fprintf(ftxt,"\n\tUnknown(%08X)=%d,%d",getnum(p+4,4),getnum(p,2),getnum(p+2,2));
	}
}

// A frame can have up to 255 buttons or frames

void frame(int p)
{
//	fprintf(ftxt,", size=%d,%d, ", getnum(p,2),getnum(p+2,2));
//	printstring(getnum(p+4,4));
//	fprintf(ftxt,", font=%s", fontname[getnum(p+16,1)]);

	int items = getnum(p+18,1);
	if (items) {
//		fprintf(ftxt,"\n\t>> %d",items);
		int address = p+20;
		while(items--) {
			item(address);
			address = address +9;
		}
//		fprintf(ftxt,"\n\t<<");
	}
}

bool
macro_has_ircode(int p)
{
	bool	has_ircode = false;
	
	int steps = mem[p];
	int address = p+2;
	while(steps--) {
		if (mem[address]==1) {
			has_ircode = true;
			break;
		}
		address += 9;
	}
	return has_ircode;
}

// a button

void button(int p)
{
	if (macro_has_ircode(getnum(p+4, 4))) {
//		fprintf(ftxt,", size=%d,%d, ", getnum(p,2),getnum(p+2,2));
		fprintf(ftxt, "\n\t");
		printstring(getnum(p+8,4));
//		fprintf(ftxt,", font=%s", fontname[getnum(p+16,1)]);
//		fprintf(ftxt,", %08X %08X %08X %08X", getnum(p+18,4), getnum(p+22,4), getnum(p+26,1), getnum(p+30,1));
//		fprintf(ftxt,", col=%08X",getnum(p+34,4));
		macro(getnum(p+4,4));
	}
}

// List a macro, up to 255 steps, IR code, Alias, Jump or Delay

void macro(int p)
{
	int steps = mem[p];
	int address = p+2;
	while(steps--) {
		if (mem[address]==1) {
			// IR code
			ircode(getnum(address+5,4));
		}
#if 0
		else if (mem[address]==2) {
			// Alias
			fprintf(ftxt,"\n\t\tAlias: ");
			printstring(getnum(getnum(address+1,4)+4,4));
			putc(' ',ftxt);
			printstring(getnum(getnum(address+5,4)+8,4));
		}
		else if (mem[address]==3) {
			// Jump
			if (getnum(address+1,4)) {
				fprintf(ftxt,"\n\t\tJump: ");
				printstring(getnum(getnum(address+1,4)+4,4));
				putc(' ',ftxt);
				printstring(getnum(getnum(address+5,4)+4,4));
			}
			else { //special fn
				if (getnum(address+5,4)==0xDDDDDDDD)
					fprintf(ftxt,"\n\t\tSCROLL DOWN");
				else if (getnum(address+5,4)==0xEEEEEEEE)
					fprintf(ftxt,"\n\t\tSCROLL UP");
				else 
					fprintf(ftxt,"\n\t\tUNKNOWN SPECIAL FUNCTION");
			}
		}
		else if (mem[address]==4) {
			// DELAY
			if (getnum(address+1,4))
				fprintf(ftxt,"\n\t\tDelay: %08X %d msec", getnum(address+1,4), getnum(address+5,4));
			else
				fprintf(ftxt,"\n\t\tDelay: %d msec", getnum(address+5,4));
		}
		else if (mem[address]==5) {
			// Hard button
			fprintf(ftxt,"\n\t\tHard: "); 
			printstring(getnum(getnum(address+1,4)+4,4));
			fprintf(ftxt," %s", buttonname[getnum(address+5,4)]);
		}
		else if (mem[address]==6) {
			// Device Alias
			fprintf(ftxt,"\n\t\tDevice alias: "); 
			printstring(getnum(getnum(address+1,4)+4,4));
		}	
		else {
			fprintf(ftxt,"\n\t\tUnknown macro step: %02X %08X %08X", mem[address], getnum(address+1,4), getnum(address+5,4));
		}
#endif
		address += 9;
	}
}

// print a IR Code,
// converting to device and function if possible 
// This seems to be much harder than it should be

void ircode(int address)
{
	INFO in;
	in.ftxt = ftxt;
	int	saveAddress = address;
	int ln = getnum(address,2)-6;

	address += 6;
	int kind = getnum(address,2);
	int newVersionFudge = 0;
	int	lengthFudge = ln;

	if (kind==0 || kind==0x100) {
		if (getnum(address+4,2) == 0 && getnum(address+6,2) == 0) {
			newVersionFudge = 6;
		}
		float units = getnum(address+2 + newVersionFudge,2) * .241246;
		float freq = in.freq = (kind==0 && units!=0.0) ? (1000.0/units) : 0.0;
		int once = in.once = getnum(address+4+newVersionFudge,2);
		int again = in.again = getnum(address+6+newVersionFudge,2);

		if ((once+again)*4+8 != ln - newVersionFudge)
        {
			fprintf(ftxt,"Inconsistent lengths: %d total bytes != 14 overhead + 4*(%d once + %d again)\n",ln+6-newVersionFudge,once,again);
        }
        else
        {
		    fprintf(ftxt, "\t");
		    printstring(getnum(saveAddress+2,4));
		    address += 8 + newVersionFudge;
		    ln = (once+again)*2;
		    lengthFudge = 8 + 4 * (once + again);
		    float *fp = in.ffp = new float[ln];
		    for (int index=0; index<ln; index++) {
			    fp[index] = units * getnum(address,2);
			    address += 2;
		    }
		    decoder(in);
		    fprintf(ftxt,"\tfreq=%.1fKHz\n", freq);
		    delete [] fp;
        }
	}

	fprintf(ftxt,"\t");
	saveAddress += 6;
	saveAddress += newVersionFudge;

	for (int p=saveAddress; p<saveAddress+lengthFudge/*ln*2 - 6 + lengthFudge*/; p+=2)
		fprintf(ftxt,"%04X ", getnum(p,2));
	fprintf(ftxt,"\n");

}

// a string is 1 byte length followed by the characters

struct {
	char*	fSymbol;
	char*	fText;
} SymbolTable[] = {
	"", "Power Toggle" ,
	"", "Stop",
	"", "Pause" ,
	"", "Play" ,
	"", "Reverse Play",
	"", "Eject" ,
	"", "Step Forward" ,
	"", "Step Back" ,
	"", "Track Forwards" ,
	"", "Track Back" ,
	"", "Scan Back" ,
	"", "Scan Forward" ,
	"", "Down Arrow",
	"", "Up Arrow",
	"", "Left Arrow" ,
	"", "Right Arrow" ,
};

void printstring(int p)
{
	if (p < 0) {
		p &= 0x7FFFFFFF;
	//	fprintf(ftxt,"^s^");
	}

	if (p>endmem) {
		fprintf(ftxt,"Error in string address 0x%X", p);
		return;
	}
	int l = mem[p++];
	putc('\"',ftxt);

	int	symbolFound = -1;

	if (l == 1) {
		for (int i = 0; i < sizeof(SymbolTable) / (sizeof(char*) * 2); i++) {
			if (SymbolTable[i].fSymbol[0] == mem[p]) {
				symbolFound = i;
				break;
			}
		}
	}

	if (symbolFound == -1) {
		while (l--) 
			putc(mem[p++],ftxt);
	} else {
		fputs(SymbolTable[symbolFound].fText, ftxt);
	}
	putc('\"',ftxt);
}

// numbers and addresses are stored high byte first

int getnum(int p, int l)
{
	if (p < 0) {
		p &= 0x7FFFFFFF;
	//	fprintf(ftxt,"^n^");
	}

	if (p>endmem) {
		fprintf(ftxt,"Error in address");
		return 0;
	}
	int v = 0;
	while (l--)
		v = (v * 256) + (mem[p++]&0xFF);
	return v;
}

void clear(INFO &in)
{
	in.ones=0;
	in.bufr.d[0] = in.bufr.d[1] = 0;
	for (int index=0; index<8; index++) {
		in.fstats[index] = 0.0;
		in.istats[index] = 0; }
}

void statdiv(INFO &in)
{
	for (int index=0; index<8; index++)
		if (in.istats[index])
			in.fstats[index] /= in.istats[index];
}

void pwm(INFO &in, float *fp, int xcount, float cutoff, int phase)
{
	clear(in);
	int count = xcount;
	int index = 0;
	int bit = 1;
	int last;
	do {
		if (*fp >= cutoff) {
			in.ones++;
			in.fstats[2] += fp[0];
			in.fstats[last=3] += fp[phase];
			in.bufr.b[index] |= bit; }
		else {
			in.fstats[0] += fp[0];
			in.fstats[last=1] += fp[phase]; }
		fp += 2;
		bit <<= 1;
		if (bit==256) {
			bit = 1;
			index++; }
	} while (--count >0);

	in.istats[0] = in.istats[1] = xcount - in.ones;
	in.istats[2] = in.istats[3] = in.ones;
	if (phase==1) {
		in.istats[last]--;
		in.fstats[last] -= fp[-1]; } // Ignore trailing sample
	statdiv(in);
	in.unit = (in.fstats[0] + in.fstats[1]) * 0.5;
	if (in.unit<10.0)
		in.unit = 10.0;
}

void pwm2(INFO &in, float *fp, int xcount, float cutoff)
{
	clear(in);
	int count = xcount;
	int index = 0;
	int bit = 1;
	do {
		if (*fp >= cutoff) {
			in.ones++;
			in.fstats[7] += fp[0];
			in.fstats[6] += fp[-1];
			in.fstats[5] += fp[-2];
			in.fstats[4] += fp[-3];
			in.bufr.b[index] |= bit; }
		else {
			in.fstats[3] += fp[0];
			in.fstats[2] += fp[-1];
			in.fstats[1] += fp[-2];
			in.fstats[0] += fp[-3];
		}
		fp += 4;
		bit <<= 1;
		if (bit==256) {
			bit = 1;
			index++; }
	} while (--count >0);

	in.istats[0] = in.istats[1] = in.istats[2] = in.istats[3] = xcount - in.ones;
	in.istats[4] = in.istats[5] = in.istats[6] = in.istats[7] = in.ones;
	statdiv(in);
	in.unit = __max(in.fstats[1], in.fstats[5]);
	if (in.unit<10.0)
		in.unit = 10.0;
}

void SayWhere(INFO &in, bool single=false)
{
	bool all1 = (in.count == in.once && in.fp == in.ffp);
	bool all2 = (in.count == in.again && in.fp == in.ffp+in.once*2);
	for (;;) {
		if (single) {
			if (all1)
				break; }
		else {
			if (all2)
				break; }
		int where=(in.fp-in.ffp)/2;
		bool in1 = (where<in.once);
		if (!in1)
			where -= in.once;
//		fprintf(in.ftxt, "  {");
		if (where)
//			fprintf(in.ftxt, "offset %d ", where );
//		fprintf(in.ftxt, in1 ? "in single" : "in repeated");
//		fprintf(in.ftxt, " part");
		if (!all1 && !all2) {
//			fprintf(in.ftxt, " using %d of %d pairs",
//				in.count, in1 ? in.once : in.again, where );
		}
//		fprintf(in.ftxt, "}");
		break; }
//	fprintf(in.ftxt, "\n");
}

void PWM_Stats0(INFO &in)
{
	fprintf(in.ftxt, "\t\t\tTimeBase=%.0f",	in.unit);
}

void PWM_Stats1(INFO &in)
{
	fprintf(in.ftxt, "  Prefix=%.1f,%.1f", in.fp[0]/in.unit, -in.fp[1]/in.unit);
}

void PWM_Stats2(INFO &in)
{
	fprintf(in.ftxt, "  Zero=%.1f,%.1f  One=%.1f,%.1f",
		in.fstats[0]/in.unit, -in.fstats[1]/in.unit,
		in.fstats[2]/in.unit, -in.fstats[3]/in.unit);
}


void GWM_Stats2(INFO &in)
{
	fprintf(in.ftxt, "  Zero=%.1f,%.1f  One=%.1f,%.1f",
		in.fstats[1]/in.unit, -in.fstats[0]/in.unit,
		in.fstats[3]/in.unit, -in.fstats[2]/in.unit);
}

void PWM_Stats3(INFO &in)
{
	fprintf(in.ftxt, "  Suffix = %.1f", -in.fp[in.count*2-1]/in.unit);
}

void GWM_Stats3(INFO &in)
{
	int end = (in.count-1)*2;
	fprintf(in.ftxt, "  Suffix = %.1f,%.1f", in.fp[end]/in.unit, -in.fp[end+1]/in.unit);
}

void PWM_Stats4(INFO &in)
{
	fprintf(in.ftxt, "  Total = %.0f", in.Total/in.unit);
}

void PWM_Stats01234(INFO &in)
{
	PWM_Stats0(in);
	PWM_Stats1(in);
	PWM_Stats2(in);
	PWM_Stats3(in);
	PWM_Stats4(in);
}

void GWM_Stats01234(INFO &in)
{
//	PWM_Stats0(in);
//	PWM_Stats1(in);
//	GWM_Stats2(in);
//	GWM_Stats3(in);
//	PWM_Stats4(in);
}

void decoder(INFO &in)
{
	int count = in.once + in.again;
	in.pulses = new float [count];
	in.gaps   = new float [count];

	//If the dll was successfully loaded, try to use it
	if (hDll != NULL) 
		TryDLL(in);

	for (int start=0; start<count; ) {
		for (int end=start+1; end<count; end++)
			if ( end==in.once-1 || end==count-1
				 || in.ffp[end*2-1]*8. < in.ffp[end*2+1] )
			{
				in.fp = in.ffp+start*2;
				in.count = end+1-start;
				in.Total = 0.0;
				for (int index=0; index<in.count; index++) {
					in.Total += in.pulses[index] = in.fp[index*2];
					in.Total += in.gaps[index] = in.fp[index*2+1]; }
				std::sort(in.gaps, in.gaps+in.count);
				if (in.gaps[in.count-1] > in.gaps[in.count-2]*2.0 || end==in.once-1 || end==count-1) {
					std::sort(in.pulses, in.pulses+in.count);
					TryPANASONIC(in);
					TryNEC(in);
					TryOldPanasonic(in);
					TryS42(in);
					TryRCA(in);
					TryJVC(in);
					TryS16a(in);
					TrySHARP(in);
					TryRC(in);
					TrySONY(in);
					TryJerrold(in);
					TryFurby(in);
				}
				if (in.ffp[end*2-1]*20. < in.ffp[end*2+1])
					break; }
		do {
			start++;
		} while ( start <= end && start != in.once && in.ffp[start*2-1] < in.ffp[start*2+1]*8.0);
	}

	// Special kludge for X10
	in.count = 0;
	for (int end = 0; end<count; end++)
		if (in.ffp[end*2] < (650. * 16.) )
			in.count++;
		else {
			if (in.count >= 11) {
				in.fp = in.ffp + end*2 - 22;
				in.count = 12;
				for (int index=0; index<in.count; index++) {
					in.pulses[index] = in.fp[index*2];
					in.gaps[index] = in.fp[index*2+1]; }
				std::sort(in.gaps, in.gaps+in.count);
				std::sort(in.pulses, in.pulses+in.count);
				TryX10IR(in);
			}
			in.count = 0; }


	delete [] in.pulses;
	delete [] in.gaps;
}

// Phase shift encoding
//
// count is in samples, not pairs
// 
// measuring samples
//  less than cutoff[state] ==> 1
//  between cutoff[state] and 2*cutoff[state] ==> 2
//  greater than 2*cutoff[state] ==> Error
//  
// decoding rules:
//  1,1 ==> this bit = state
//  2   ==> this bit = state = (1 - state)
//  1,2 ==> Error, shouldn't happen in this protocol
//
// termination rule
//   quit when count==0 or (count==1 and this_sample==1)
//
int phase_shift(INFO &in, float *fp, int count, int state, float *cutoff)
{
	clear(in);

	int bits=0;
	do {
		if (*fp < cutoff[state])  { // sample == 1
			if (--count == 0)
				break;
			if (*++fp >= cutoff[1-state])  // next_sample != 1
				return 0;
			in.istats[state]++;
			in.fstats[state] += fp[-1];
			in.istats[state+2]++;
			in.fstats[state+2] += fp[0]; }
		else {
			if (*fp >= 2*cutoff[state]) // sample > 2
				return 0;
			in.istats[state+4]++;
			in.fstats[state+4] += fp[0];
			state = 1-state; }
		++fp;
		if (state)
			in.bufr.b[bits>>3] |= 1<<(bits & 7);
		bits++;
	} while (--count > 0);
	in.last = state;
	statdiv(in);
	return bits;
}

int obc2efc(int obc)
{
	// Reverse the order of bits
	obc = (obc<<4) + (obc>>4);
	obc = ((obc&0x33)<<2) + ((obc&0xCC)>>2);
	obc = ((obc&0x55)<<1) + ((obc&0xAA)>>1);

	// Rotate left three places  (ignoring affect on bits 8-10)
	obc = (obc<<3) + (obc>>5);

	// XOR with 0x51;
	obc ^= 0x51;

	// Add 100 (ignoring affect on bits 8-10)
	obc += 100;

	// Return only low 8 bits
	return obc & 0xFF;
}

unsigned long reverse(unsigned long val)
{
	val = (val<<16) + (val>>16);
	val = ((val&0xFF00FF)<<8) + ((val>>8)&0xFF00FF);
	val = ((val&0xF0F0F0F)<<4) + ((val>>4)&0xF0F0F0F);
	val = ((val&0x33333333)<<2) + ((val>>2)&0x33333333);
	return ((val&0x55555555)<<1) + ((val>>1)&0x55555555);
}

// N bits, pulse encode with prefix
//
// Frequency=40000
// Time Base=600
// One=2,-1
// Zero=1,-1
// Prefix=4,-1
// Message Time=45000
// Form=*,f:7,d:?
//
int TrySONY(INFO &in)
{
	char szProtocol[32];
	int Result;

	if (in.gaps[0]*1.5 < in.gaps[in.count-2])
		return 0;  // All but terminal gap should be the same size

	if (in.count < 6)
		return 0;  // Five bit minimum

	float cutoff = ( in.pulses[0] + in.pulses[in.count-2] ) * .5;

	// If all the pulses are the same size, fall back on expected timing
	if (in.pulses[0]*1.5 > in.pulses[in.count-2]) {
		if (in.freq<36000. || in.freq>44000.)
			return 0;
		if (in.pulses[in.count-2] > 2000.)
			return 0;
		if (in.gaps[0] < 300. || in.gaps[in.count-2] > 800.)
			return 0;
		cutoff = 800.0; }

	pwm(in, in.fp+2, in.count-1, cutoff, 1);

	if (in.istats[0] == 0)  // Saw no "0" bits
		in.unit = (in.fstats[2]+in.fstats[3]) * 0.3334;

	
	sprintf(szProtocol,"SONY%d",in.count -1);
	if (ProtocolSupportLevel(szProtocol) == 0) {
		fprintf(in.ftxt, "\t(SONY%d):", in.count-1);
		int cmd = in.bufr.b[0];
		if (in.count>9)
		{
			if (in.count == 21) {
				// for SONY20, print in 5.8 format
				fprintf(in.ftxt, "%d.%d", (in.bufr.l >> 7) & 0x1f,
					(in.bufr.l >> 12) & 0xff);
			} else {
				fprintf(in.ftxt, "%d", in.bufr.l >> 7);
			}
			cmd &= 127;
		}
		fprintf(in.ftxt, ":%d", cmd);
		if (in.count > 9)
			fprintf(in.ftxt, "  EFC = %03d ? %03d", obc2efc(255-cmd), obc2efc(127-cmd));
		SayWhere(in);
		//	PWM_Stats01234(in);
		//	fprintf(in.ftxt, "\n");
		Result = 10;
	};

	return Result;
}

// 22 bits. Gap encoded with prefix
//
//  Old Panasonic = *,D:5,F:6,~D:5,~F:6,_
//
int TryOldPanasonic(INFO &in)
{
	if (in.count != 24)
		return 0;

	int result = 80;

	// There should be 11 zeroes and 11 ones.  Base cutoff on that
	float cutoff = (in.gaps[10]+in.gaps[11]) * 0.5;
	pwm(in, in.fp+3, 22, cutoff, -1);

	int module = in.bufr.l & 31;
	int cmd = (in.bufr.l >> 5) & 63;

	if (ProtocolSupportLevel("Old Panasonic") == 0) {
		fprintf(in.ftxt, "\t(Old Panasonic)");

		if (((in.bufr.l >> 11) + in.bufr.l + 1) & 0x7FF) {
			result = 10;
			fprintf(in.ftxt, " Error 0x%lX ", in.bufr.l); }

		fprintf(in.ftxt, ":%d:%d", module, cmd);

		if (module==cmd)
			fprintf(in.ftxt, "  EFC=%03d", obc2efc(254-cmd*2));
		else
			fprintf(in.ftxt, "  EFC = %03d ? %03d ? %03d", obc2efc(63-cmd), obc2efc(127-cmd), obc2efc(191-cmd));

		SayWhere(in);
	//	GWM_Stats01234(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// 24 bits. Gap encoded with prefix
//
//     S24:   *,D:4,~D:4,F:8,~F:8,_
//
//  If (Freq > 50Khz)
//
//     RCA:   *,D:-4,F:-8,~D:-4,~F:-8,_
//
//  If (Freq < 50Khz)
//
//     Emerson:  *,D:6,F:6,~D:6,~F:6,_
//
int TryRCA(INFO &in)
{
	char szProtocol[255];

	if (in.count != 26)
		return 0;

	int result = 80;

	// There should be 12 zeroes and 12 ones.  Base cutoff on that
	float cutoff = (in.gaps[11]+in.gaps[12]) * 0.5;
	pwm(in, in.fp+3, 24, cutoff, -1);

	if (in.bufr.b[1] == 255 - in.bufr.b[2] && (in.bufr.b[0]>>4)==15-(in.bufr.b[0]&15))
	{
		if (ProtocolSupportLevel("S24") == 0) {
			fprintf(in.ftxt, "\t(S24)");
			fprintf(in.ftxt, ":%d:%d", in.bufr.l&15, in.bufr.b[1]);
			fprintf(in.ftxt, "  ?EFC = %03d", obc2efc( in.bufr.b[1] ) );
			SayWhere(in);
	//		GWM_Stats01234(in);
			fprintf(in.ftxt, "\n");
		};
		return result;
	}

	int msb = reverse(in.bufr.l)>>20;

	bool isRCA = (in.freq > 50.0);

	sprintf(szProtocol,isRCA ? "RCA" : "Emerson");
	if (ProtocolSupportLevel(szProtocol) == 0) {
		fprintf(in.ftxt, isRCA ? "\t(RCA)" : "\t(Emerson)");

		if (((in.bufr.l >> 12) + in.bufr.l + 1) & 0xFFF) {
			result = 10;
			fprintf(in.ftxt, " Error 0x%lX ", in.bufr.l); }

		if (isRCA) {
			in.unit = (in.fstats[1] + in.fstats[3]) * 0.5;
			fprintf(in.ftxt, ":%d:%d ", msb>>8, msb&255);
			fprintf(in.ftxt, "  ?EFC = %03d", obc2efc( 255 - ((in.bufr.l>>4)&255) )); }

		else {
			fprintf(in.ftxt, ":%d:%d", in.bufr.l&63, (in.bufr.l>>6)&63);
			fprintf(in.ftxt, "  ?EFC = %03d", obc2efc( 255 - ((in.bufr.l>>4)&255) )); }

		SayWhere(in);
	//	GWM_Stats01234(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// 32 bit gap encoded with prefix
//
//  NEC:  *,D:8,S:8,F:8,~F:8,_ ; *,_
//
//  NEC2: *,D:8,S:8,F:8,~F:8,_
//
int TryNEC(INFO &in)
{
	char szProtocol[255];

	if (in.count != 34)
		return 0;

	int result = 80;

	// There are at least 8 zeroes and at least 8 ones.  Base cutoff on that
	float cutoff = (in.gaps[7]+in.gaps[24]) * 0.5;
	pwm(in, in.fp+3, 32, cutoff, -1);

	sprintf(szProtocol,(in.again == 2) ? "NEC" : "NEC2");
	if (ProtocolSupportLevel(szProtocol) == 0) {
		fprintf(in.ftxt, (in.again == 2) ? "\t(NEC)" : "\t(NEC2)");

		int cmd=in.bufr.b[2];
		if (in.bufr.b[3] != 255-cmd) {
			if ((in.bufr.b[3] & 0xf0) == (~cmd & 0xf0)) {
				// TiVo format signal
				fprintf(in.ftxt, " Unit=%d ", in.bufr.b[3] & 0xf);
			} else {
				result = 10;
				fprintf(in.ftxt, " Error 0x%lX ", in.bufr.l);
			}
		}
		fprintf(in.ftxt, ":%d", in.bufr.b[0]);
		if (in.bufr.b[1] != 255-in.bufr.b[0])
			fprintf(in.ftxt, ".%d", in.bufr.b[1]);
		fprintf(in.ftxt, ":%d  EFC=%03d", cmd, obc2efc(cmd));

		SayWhere(in, in.again==2);

	#if 0
		GWM_Stats01234(in);

		if (in.again==2) {
			float * hold = in.ffp+in.once*2;
			fprintf(in.ftxt, "  Hold=%.1f,%.1f,%.1f,%.1f",
			hold[0]/in.unit, -hold[1]/in.unit,
			hold[2]/in.unit, -hold[3]/in.unit); }
	#endif

	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// 42 bits gap encoded with prefix
//
//  S42:  *,D:13,~D:13,F:8,~F:8,_
//
int TryS42(INFO &in)
{
	if (in.count != 44)
		return 0;

	int result = 20;

	float cutoff = (in.gaps[21]+in.gaps[22]) * 0.5;
	pwm(in, in.fp+3, 42, cutoff, -1);

	if (ProtocolSupportLevel("s42") == 0) {
		fprintf(in.ftxt, "\t(s42)");

		int mdl = in.bufr.l & 0x1FFF;
		int cmd = (in.bufr.b[3]>>2) + ((in.bufr.b[4]<<6)&0xFF);

		if (   ((in.bufr.l>>13)+mdl+1)&0x1FFF
			|| in.bufr.d[1]>>2 != 255-cmd )
		{
			result = 10;
			fprintf(in.ftxt, " Error 0x%03lX%lX ", in.bufr.d[1],in.bufr.l); }

		fprintf(in.ftxt, ":%d:%d  EFC=%03d", mdl, cmd, obc2efc(255-cmd));

		SayWhere(in, in.again==2);
	//	GWM_Stats01234(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// 48 bits gap encoded with prefix
//
//  Panasonic:  *,2:8,32:8,D:8,S:8,F:8,C:8,_   {C=D^S^F}
//
int TryPANASONIC(INFO &in)
{
	if (in.count != 50)
		return 0;

	int result = 80;
	float cutoff = (in.fp[3]+in.fp[5]) * 0.5;
	pwm(in, in.fp+3, 48, cutoff, -1);

	if (ProtocolSupportLevel("PANASONIC") == 0) {
		fprintf(in.ftxt, "\t(PANASONIC)");

		if (in.bufr.b[0] != 2 || in.bufr.b[1] != 32 || in.bufr.b[5] != (in.bufr.b[2] ^ in.bufr.b[3] ^ in.bufr.b[4])) {
			result = 10;
			fprintf(in.ftxt, " Error %04lX%08lX ", in.bufr.d[1], in.bufr.l); }

		if (in.bufr.b[3] == 0)
			fprintf(in.ftxt, ":%d:%d", in.bufr.b[2], in.bufr.b[4]);
		else
			fprintf(in.ftxt, ":%d.%d:%d", in.bufr.b[2], in.bufr.b[3], in.bufr.b[4]);
		fprintf(in.ftxt, " EFC = %03d", obc2efc(in.bufr.b[4]));

		SayWhere(in);
	//	GWM_Stats01234(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// 15 bits gap encoded, no prefix
//
// Frequency=37917
// Time Base=264       '10 cycles
// Zero=1,-3
// One=1,-7
// Suffix=1,-165
//
//  SHARP:   D:5,F:8,1:2,_,D:5,~F:8,2:2,_
//
//  DENON:   D:5,F:8,0:2,_,D:5,~F:8,3:2,_
//
int TrySHARP(INFO &in)
{
	char szProtocol[255];

	if (in.count!=16)
		return 0;

	if (in.pulses[15] > in.gaps[0])   // The biggest pulse should be smaller than the
		return 0;                     // smallest gap.

	if (in.gaps[0]*1.5 > in.gaps[14]) // The big gaps should be more than 50% larger
		return 0;                     // than the little ones

	int result = 50;
	float cutoff = (in.gaps[0] + in.gaps[14]) * 0.5;  // Assume at least one "0" and one "1"

	pwm(in, in.fp+1, 15, cutoff, -1);             // No prefix

	in.unit = (in.fstats[1] + in.fstats[3]) * 0.5;

	int vl=in.bufr.l;

	bool second = ((vl & 0x4000) != 0);  // Back half of alternation
	if (second)
		vl ^= 0x7FE0;                    // Reconstruct front half

	sprintf(szProtocol,(vl & 0x2000)? "SHARP" : "DENON");
	if (ProtocolSupportLevel(szProtocol) == 0) {

		if (vl & 0x2000) {
			fprintf(in.ftxt, "\t(SHARP)");
			vl &= 0x1FFF; }
		else
			fprintf(in.ftxt, "\t(DENON)");

		fprintf(in.ftxt, ":%d:%d  ?EFC=%03d", vl & 31, vl>>5, obc2efc(255 - (vl>>5)));
		if (second)
			fprintf(in.ftxt," back half");

		SayWhere(in);
	//	PWM_Stats0(in);
	//	GWM_Stats2(in);
	//	GWM_Stats3(in);
	//	PWM_Stats4(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// 16 bits gap encoded, with prefix
//
//  If (Zero==1,-1)
//
//     JVC1:  *,D:8,F:8,_
//
//  If (Zero==1,-4.5)
//
//     S16b:  *,F:8,D:4,~C:4,_  {Define C = 15+D+F(0..3)+F(4..7)}
//
int TryJVC(INFO &in)
{
	char szProtocol[255];

	if (in.count!=18)
		return 0;
	if (in.fp[0] <= in.pulses[16])
		return 0;  // True prefix required to avoid confusion with JVC-A
	int result = 50;
	float cutoff = (in.gaps[0] + in.gaps[15]) * 0.5;
	pwm(in, in.fp+3, 16, cutoff, -1);

	{
		bool is16b = ( in.fstats[1] * 2.0 < in.fstats[0] );

		if (is16b) {
			in.unit = (in.fstats[1] + in.fstats[3]) * 0.5;
			if (ProtocolSupportLevel("s16b") == 0) {
				fprintf(in.ftxt, "\t(s16b)");
				int b0 = in.bufr.b[0];
				int b1 = in.bufr.b[1];
				if ((b0 + b1 + (b0>>4) + (b1>>4)) & 15)
					fprintf(in.ftxt, " Error 0x%04X ", in.bufr.l);	
				fprintf(in.ftxt, ":%d:%d  ?EFC=%03d", b1 & 15, b0, obc2efc(b0)); };
				SayWhere(in);
			}
		else {
			sprintf(szProtocol,(in.freq > 36.0) ? "JVC1" : "s16");
			if (ProtocolSupportLevel(szProtocol) == 0) {
				fprintf(in.ftxt, (in.freq > 36.0) ? "\t(JVC1)" : "\t(s16)");
				fprintf(in.ftxt, ":%d:%d  EFC=%03d", in.bufr.b[0], in.bufr.b[1], obc2efc(in.bufr.b[1])); };
				SayWhere(in);
			}
	}


//	GWM_Stats01234(in);
//	fprintf(in.ftxt, "\n");

	return result;
}

// 16 bits gap encoded, no prefix
//
//  If (Freq > 50Khz)
//
//      JVC-A:  F:8,D:8,_
//
//  Else If (Freq > 36Khz)
//
//      JVC2:  D:8,F:8,_
//
//  If (Freq < 36Khz)
//
//      S16a:  D:8,F:8,_
//
int TryS16a(INFO &in)
{
	char szProtocol[255];

	if (in.count!=17)
		return 0;
	int result = 50;
	float cutoff = (in.gaps[0] + in.gaps[15]) * 0.5;
	pwm(in, in.fp+1, 16, cutoff, -1);             // No prefix

	in.unit = (in.fstats[1] + in.fstats[3]) * 0.5;

	if (in.freq > 50.0)
	{
		if (ProtocolSupportLevel("JVC-A") == 0) {
			fprintf(in.ftxt, "\t(JVC-A)");
			fprintf(in.ftxt, ":%d:%d  ?EFC=%03d", in.bufr.b[1], in.bufr.b[0], obc2efc(in.bufr.b[0]));
			SayWhere(in);
		};
	}
	else
	{
		sprintf(szProtocol,(in.freq > 36.0) ? "JVC2" : "s16a");
		if (ProtocolSupportLevel(szProtocol) == 0) {
			fprintf(in.ftxt, (in.freq > 36.0) ? "\t(JVC2)" : "\t(s16a)");
			fprintf(in.ftxt, ":%d:%d  EFC=%03d", in.bufr.b[0], in.bufr.b[1], obc2efc(in.bufr.b[1]));
			SayWhere(in);
		};
	}


//	PWM_Stats0(in);
//	GWM_Stats2(in);
//	GWM_Stats3(in);
//	PWM_Stats4(in);
//	fprintf(in.ftxt, "\n");

	return result;
}

int TryRC(INFO &in)
{
	if (in.count<4)
		return 0;
	float cutoff[2];
	cutoff[0] = in.fp[1]*1.5;  // Cutoff for Gaps
	if (cutoff[0] < in.fp[0])  // Don't use this encoding if there is a large AGC,
		return 0;              //    or the first gap is tiny.
	cutoff[1] = in.fp[0]*1.5;  // Cutoff for Pulses

	int bits = phase_shift(in, in.fp+2, in.count*2-3, 1, cutoff);
	if (bits<5)
		return 0;
	if (in.istats[5] == 0) {
		// This means there are no phase changes.  Usually that indicates that the signal
		// is not phase encoded.
		// It could indicate that all the bits are "1".  I know of no decent way to distinguish
		// phase encoding with all bits "1" from other encodings;  Hopefully no one uses
		// all 1's for device and function in phase encoding.
		return 0; }

	int result = 10;
	if (bits==12) {
		int val = reverse(in.bufr.l)>>20;
		int cmd = val&63;
		int rcmd = in.bufr.l >> 6;
		if (ProtocolSupportLevel("RC5") == 0) {
			fprintf(in.ftxt, "\t(RC5):%d:%d", (val>>6)&31, cmd);
			if (val & 0x800)
				fprintf(in.ftxt, " ODD");
			fprintf(in.ftxt, "  ?EFC %03d ? %03d ? %03d ? %03d", obc2efc(rcmd), obc2efc(rcmd+64), obc2efc(rcmd+128), obc2efc(rcmd+192));
			SayWhere(in);
			result = 50; 
		};
		}
	else {
		int index = (bits-1)/8;
		fprintf(in.ftxt, "\tSome kind of phase encoding, %d bits, LSB value = 0x%X", bits, in.bufr.b[index]);
		while (--index >= 0)
			fprintf(in.ftxt, "%02X", in.bufr.b[index]); 
		SayWhere(in);
	};

	

#if 0
	in.unit = (in.fp[0]+in.fp[1]) * 0.5;
	fprintf(in.ftxt,"\t\t\ttimebase=%.0f", in.unit);
	fprintf(in.ftxt, " Zero = %.1f,%.1f or %.1f", -in.fstats[0]/in.unit, in.fstats[2]/in.unit, in.fstats[5]/in.unit);
	fprintf(in.ftxt, " One = %.1f,%.1f or %.1f", in.fstats[1]/in.unit, -in.fstats[3]/in.unit, -in.fstats[4]/in.unit);
	fprintf(in.ftxt, " Prefix = %.1f,%.1f", in.fp[0]/in.unit, -in.fp[1]/in.unit);
	fprintf(in.ftxt, " Suffix = ");
	if (in.last)
		fprintf(in.ftxt, "%.1f,", in.fp[in.count*2-2]/in.unit);
	fprintf(in.ftxt, "%.1f", -in.fp[in.count*2-1]/in.unit);
	PWM_Stats4(in);
#endif
//	fprintf(in.ftxt, "\n");
	return result;
}

// 5 bits gap encoded, no prefix
// Frequency=0
//
//  Jerrold:  F:5,_
//
int TryJerrold(INFO &in)
{
	if (in.count != 6  || in.freq != 0.0)
		return 0;

	if (in.pulses[5]*10.0 > in.gaps[0])   // The biggest pulse should be MUCH smaller than the
		return 0;                         // smallest gap.

	int result = 50;
	float cutoff = 9300.0;

	pwm(in, in.fp+1, 5, cutoff, -1);             // No prefix

	in.unit = 10.0;
	if (ProtocolSupportLevel("JERROLD") == 0) {
		fprintf(in.ftxt, "\t(JERROLD)");
		fprintf(in.ftxt, "::%d  EFC=%03d", in.bufr.l, obc2efc(31 - in.bufr.l));

		SayWhere(in);
	//	PWM_Stats0(in);
	//	GWM_Stats2(in);
	//	GWM_Stats3(in);
	//	PWM_Stats4(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

int TryFurby(INFO &in)
{
	if (in.count!=28)
		return 0;

	if (in.gaps[13]*3.0 > in.gaps[14])
		return 0;

	int result = 50;
	float cutoff = in.gaps[13] * 8.0;

	pwm2(in, in.fp+3, 13, cutoff);

	if (ProtocolSupportLevel("Furby") == 0) {
		fprintf(in.ftxt, "\t(Furby)");

		fprintf(in.ftxt, "::0x%X", in.bufr.l);

		SayWhere(in);
	#if 0
		PWM_Stats0(in);

		fprintf(in.ftxt, "  Zero=%.1f,%.1f,%.1f,%.1f  One=%.1f,%.1f,%.1f,%.1f",
			in.fstats[0]/in.unit, -in.fstats[1]/in.unit, in.fstats[2]/in.unit, -in.fstats[3]/in.unit,
			in.fstats[4]/in.unit, -in.fstats[5]/in.unit, in.fstats[6]/in.unit, -in.fstats[7]/in.unit);

		fprintf(in.ftxt, "  Suffix = %.1f,%.1f,%.1f,%.1f", -in.fp[in.count*2-4]/in.unit, -in.fp[in.count*2-3]/in.unit, -in.fp[in.count*2-2]/in.unit, -in.fp[in.count*2-1]/in.unit);

		PWM_Stats4(in);
	#endif

	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

//  X10:  *,F:5,~F:5,_
//
int TryX10IR(INFO &in)
{
	int result = 50;
	float cutoff = 650. * 10.;

	pwm(in, in.fp+3, 10, cutoff, -1);

	if (ProtocolSupportLevel("X10IR") == 0) {
		fprintf(in.ftxt, "\t(X10IR)");

		int func = in.bufr.l >> 5;
		if ((31-func) != (in.bufr.l & 31)) {
			result = 10;
			fprintf(in.ftxt, " Error 0x%03lX ", in.bufr.l); }

		fprintf(in.ftxt, "::%d", func);

		SayWhere(in);
	//	GWM_Stats01234(in);
	//	fprintf(in.ftxt, "\n");
	};

	return result;
}

// DLL Decode routines
void LoadDll() 
{
	hDll = LoadLibrary("DecodeIR.dll");
	if (hDll != NULL)
	{
		lpfnDecodeIR = (typeDecodeIR)GetProcAddress(hDll,
			"DecodeIR");
		if (lpfnDecodeIR==0) {
			FreeLibrary(hDll);
			hDll = NULL;
		};

		lpfnProtocolSupportLevel = (typeProtocolSupportLevel)GetProcAddress(hDll,
			"ProtocolSupportLevel");
		if (lpfnProtocolSupportLevel==0) {
			FreeLibrary(hDll);
			hDll = NULL;
		};
	};
}

int ProtocolSupportLevel(char *Protocol) {
	if (hDll != NULL)
		return lpfnProtocolSupportLevel(Protocol);
	else
		return 0;

}

int HexCmdToEFC(int iHexCmd) {

	int Result;
	Result = ( ( ((iHexCmd << 3)+(iHexCmd >> 5)) ^ 0xAE ) + 100 ) & 0xFF;


	return Result;
}

int TryDLL_once(INFO &in, int *ip, unsigned int iaContext[2])
{
	char szProtocol[255] = "";
	int iDevice = -1;
	int iSubDevice= -1;
	int iOBC= -1;
	int lpiHex[4] = {-1,-1,-1,-1};
	char szMisc[255]= "";
	char szError[255]= "";

	//Call the DecodeIR function
	lpfnDecodeIR(iaContext, ip, (int)(in.freq*1000.),in.once,in.again,szProtocol,&iDevice,&iSubDevice,&iOBC,lpiHex,szMisc,szError);

	//Print the result
	if (szProtocol[0])  {
        fprintf(in.ftxt, "\t\t(%s):", szProtocol);
        if (iDevice != -1)
            fprintf(in.ftxt, "%d", iDevice);
        if (iSubDevice != -1)
            fprintf(in.ftxt, ".%d", iSubDevice);
        if (iOBC != -1)
            fprintf(in.ftxt, ":%d", iOBC);
        if (lpiHex[0] != -1)
        {
            fprintf(in.ftxt, " EFC=%03d", HexCmdToEFC(lpiHex[0]) );
            for (int ndx=1; ndx<4 && lpiHex[ndx]!=-1; ++ndx)
                fprintf(in.ftxt, " or %03d", HexCmdToEFC(lpiHex[ndx]) );
        }
        if (szMisc[0])
            fprintf(in.ftxt, " {%s}", szMisc);
        fprintf(in.ftxt, "\n");
		
		return 1;
	}
	
	return 0;
}

int TryDLL(INFO &in)
{
	unsigned int iaContext[2] = {0,0};
	int *ip = new int[2*(in.once + in.again)];
	int i;
	int result;

	result = 0;

	//Convert the float bursts to intetger bursts
	for (i=0;i<(2*(in.once + in.again));i++)
	{
		ip[i] = in.ffp[i];
	};

    while ( TryDLL_once(in, ip, iaContext) )
    {
		//We had at least one successful decode
        result = 80;
    }
	
	delete [] ip;

	return result;
}
