#include "stdafx.h"

int final = 0;
int NextFinal;
int pc;
int xpc;
int epc;
int xchars=0;
int W0 = 0xC0;
int W8 = 0xC8;
extern const char *inst1;
extern const char *inst2;
char buf[4096];

FILE *(outFile[3]);
int noFiles = 1;

char *PhaseError;

struct Str
{
	const char *Start;
	int Length;
};

enum
{
	e_match    = 0xF0000000,	// Features which must match exactly between a template and an operand
	e_indirect = 0x80000000,	// @
	e_index    = 0x40000000,	// []
	e_reg      = 0x20000000,	// R or W or RR or WW
	e_bit      = 0x10000000,	// .n  (operation on a specified bit)

	e_match2   = 0xFC00000,		// Features required in an operand if they are present in the template.
	e_workReg  = 0x8000000,		// W or WW
	e_even     = 0x4000000,		// register number even
	e_gt1      = 0x2000000,		// register number > 1
	e_lt256    = 0x1000000,		// number fits in a byte
	e_singleReg= 0x0800000,		// register is not RR nor WW
	e_reg2     = 0x0400000,		// register is not explicitly W or WW

								// Features that just mean something in a template, not in an operand
	e_relative = 0x1,			// 8-bit relative address
	e_msb  = 0x2,				// 16-bits stored in msb first sequence


								// Features used temporarily while parsing operands
	e_digit    = 1,
	e_c1       = 2,				// #
	e_c2       = 4,				// $
	e_symbol   = 8,
	e_last     =16				// H or ]
};

struct SINST
{
	int value;
	char *opcode;
	long operand[3];
} INST[1000], *endINST;

struct LABEL
{
	LABEL *pNext;
	char *pName;
	long value;
} *pLabels = NULL;

char *TerminateNWS(char *in)
{
	while (*(unsigned char*)in > ' ')
	{
		if (*in == ';')
		{
			*in = 0;
			return in;
		}
		++in;
	}
	if (*in)
		*in++ = 0;
	return in;
}

int cmpi(const Str &str, const char *name)
{
	return memicmp(str.Start, name, str.Length) || name[str.Length];
}

char *SkipWhite(const char *in)
{
	while (*in == ' ' || *in == '\t')
		++in;
	if (*in == ';')
		while (*in != '\r' && *in != '\n' && *in)
			++in;
	return const_cast<char*>(in);	//???
}

int ParseName( const char **inp, Str* str )
{
	(*inp) = SkipWhite(*inp);
	if ( __iscsymf(**inp) || **inp=='$' )
	{
		str->Start = *inp;
		do {++(*inp);}
			while ( __iscsym(**inp) || **inp=='$' );
		str->Length = *inp - str->Start;
		(*inp) = SkipWhite(*inp);
		return str->Length;
	}
	return 0;
}

char *NewString(const Str &str)
{
	char *n = new char[str.Length+1];
	memcpy(n, str.Start, str.Length);
	n[str.Length] = 0;
	return n;
}

char *TerminateName(char *in, char *out)
{
	if (__iscsymf(*in))
		do { ++in; }
			while (__iscsym(*in));
	if (*in == ';')
		*in = 0;
	(*out) = *in;
	if (*in)
		*in++ = 0;
	return in;
}

char *NewString(char *in)
{
	int l = strlen(in)+1;
	char *n = new char[l];
	return (char *)memcpy(n,in,l);
}

long ParseHex(const char **pptr)
{
	long result = 0xF0000000;	// Kludge assumes exactly 32 bits
	const char *ptr = *pptr - 1;
	for (;;)
	{
		char c = toupper(*++ptr);
		if (c>='0' && c<='9')
			result = (result<<4) + c-'0';
		else if (c>='A' && c<='F')
			result = (result<<4) + c-('A'-10);
		else
		{
			*pptr = ptr;
			return result;
		}
	}
}

void NewLabel(long value, const Str &str)
{
	for (LABEL *pLabel = pLabels; pLabel ; pLabel = pLabel->pNext)
	{
		const char *pName = pLabel->pName; 
		if ( memcmp(pName, str.Start, str.Length ) == 0 && pName[str.Length]==0 )
		{
			pLabel->value = value;
			return;
		}
	}
	NextFinal = 0;
	pLabel = new LABEL;
	pLabel->pNext = pLabels;
	pLabels = pLabel;
	pLabel->pName = NewString(str);
	pLabel->value = value;
}

long LookupLabel(const Str &str)
{
	for (LABEL *pLabel = pLabels; pLabel ; pLabel = pLabel->pNext)
	{
		const char *pName = pLabel->pName; 
		if ( memcmp(pName, str.Start, str.Length ) == 0 && pName[str.Length]==0 )
		{
			return pLabel->value;
		}
	}
	if ( *(str.Start) == '$' && str.Length <= 2 )
	{
		int result;
		if (str.Length == 1)
			result = pc;
		else if ( *(str.Start+1) == '$' )
			result = xpc;
		else
			return 0;
		if (result < 256)
			return result & e_lt256;
		return result;
	}
	return 0;
}


long ParseTemplate(const char **pptr)
{
	const char *ptr = *pptr;
	long result = 0;
	for (;;)
		switch (*ptr++)
		{
		case '@':
			result |= e_indirect;
			break;
		case 'W':
		case 'w':
			result |= e_reg | e_workReg | e_lt256;
			if (toupper(*ptr) == 'W')
			{
				result |= e_even;
				ptr++;
			}
			else
				result |= e_singleReg;
			break;
		case 'R':
		case 'r':
			result |= e_reg | e_reg2 | e_lt256;
			if (toupper(*ptr) == 'R')
			{
				result |= e_even;
				ptr++;
			}
			else
				result |= e_singleReg;
			break;
		case 'E':
		case 'e':
			result |= e_even;
			break;
		case 'B':
		case 'b':
			result |= e_bit;
			break;
		case ' ':
		case '\t':
			break;
		case 'A':
		case 'a':
			result |= e_msb;
			break;
		case '>':
			result |= e_gt1;
			break;
		case '+':
			result |= e_relative;
			break;
		case '#':
			result |= e_lt256;
			break;
		case '0':
			break;
		case '1':
			result |= 1<<16;
			break;
		case '2':
			result |= 2<<16;
			break;
		case '[':
			if (ptr == *pptr + 1)
			{
				result |= e_index;
				break;
			}
			// fall through
		default:
			ptr--;
			// fall through
		case ',':
			*pptr = ptr;
			return result;
		}
}

void emit(int val)
{
	val &= 0xFF;
	struct ee
	{
		short xpc;
		unsigned char val;
	};
	static int xxpc=-1;

	static ee* xe = NULL;
	static int xes = 0;
	if (xes <= epc)
	{
		xe = (ee*)realloc( xe, (xes = (xes*3+100)>>1) *sizeof(ee) );
		goto phase;
	}
	else if ( xe[epc].xpc != xpc || xe[epc].val != (unsigned char)val )
	{
phase:
		xe[epc].xpc = xpc;
		xe[epc].val = (unsigned char)val;
		if (final && NextFinal)
			PhaseError = NewString( buf );
		NextFinal = 0;
	}
	++epc;

	if (final)
	{
		if (noFiles)
			printf(" %02X", val);
		if (outFile[0])
			fprintf(outFile[0], " %02X", val);
		if (outFile[1])
		{
			if ((xpc & 15)==0 || xpc != xxpc)
				fprintf(outFile[1], "\n%03X: ", xpc);
			fprintf(outFile[1], " %02X", val);
		}
		if (outFile[2])
		{
			if (xchars==0)
			{
				fprintf(outFile[2], "%04X: ", pc);
				xchars = 6;
			}
			fprintf(outFile[2], " %02X", val);
		}
		xchars+=3;
	}
	pc++;
	xxpc = ++xpc;
}

void emiti(char *buf)
{
	if (final)
	{
		if (xchars)
		{
			if (noFiles)
				printf("\n");
			if (outFile[0])
				fprintf(outFile[0], "\n");
		}
		if (outFile[2])
		{
			if (xchars < 15)
				fprintf(outFile[2], "               "+xchars);
			fprintf(outFile[2], " %s", buf);
		}
		xchars = 0;
	}
}

void emitv(int val)
{
	if (final && outFile[2])
	{
		fprintf(outFile[2], "(%04X)", val & 0xFFFF );
		xchars += 6;
	}
}

long ParseOperand2(const char **pptr)
{
	const char *ptr = *pptr;
	Str str;
	long result = 0;
	long val = 0;
	for (;;)
	{
		if ( (result &~ (e_indirect | e_index | e_c1))==0 && ParseName(&ptr, &str) )
		{
			long syval = LookupLabel(str);
			if (syval && (syval & result)==0)
			{
				val = syval & 0xFFFF;
				result |= (syval &~ 0xFFFF) | e_symbol;
			}
			else
				ptr = str.Start;	// Reparse the name as something else
		}
		switch (*ptr++)
		{
		case '@':
			if (result)
				return 0;
			result = e_indirect;
			break;
		case 'W':
		case 'w':
			if (result &~ (e_indirect | e_index))
				return 0;
			result |= e_reg | e_workReg;
			if (toupper(*ptr) == 'W')
			{
				ptr++;
			}
			else
				result |= e_singleReg;
			break;
		case 'R':
		case 'r':
			if (result &~ (e_indirect | e_index))
				return 0;
			result |= e_reg | e_reg2;
			if (toupper(*ptr) == 'R')
			{
				ptr++;
			}
			else
				result |= e_singleReg;
			break;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
			if (result & (e_last | e_symbol))
				return 0;
			result |= e_digit;
			val = (val<<4)+ptr[-1]-('A'-10);
			break;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'e':
		case 'f':
			if (result & (e_last | e_symbol))
				return 0;
			result |= e_digit;
			val = (val<<4)+ptr[-1]-('a'-10);
			break;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			if (result & (e_last | e_symbol))
				return 0;
			result |= e_digit;
			val = (val<<4)+ptr[-1]-'0';
			break;
		case '.':
			if (result & e_last)
				return 0;
			{
				unsigned int b = *ptr++ - '0';
				if (b > 7)
					return 0;
				result |= (b<<16) | (e_bit | e_last);
			}
			break;
		case '#':
			if (result &~ e_indirect)
				return 0;
			result = e_c1;
			break;
		case '$':
			if (result &~ (e_c1 | e_indirect))
				return 0;
			result |= e_c2;
			break;
		case 'h':
		case 'H':
			if (result &~ (e_c1 | e_digit | e_indirect))
				return 0;
			result |= e_last;
			break;
		case ' ':
		case '\t':
		case '\n':
		case '\r':
			break;
		case ']':
			if ((result & (e_index | e_last)) != e_index)
				return 0;
			result |= e_last;
			break;
		case '[':
			if (result == 0)
			{
				result = e_index;
				break;
			}
			// fall through
		default:
			ptr = SkipWhite(ptr-1);
			// fall through
		case ',':
			if (val > 0xFFFF || *pptr == ptr || (result & (e_digit|e_symbol))==0)
				return 0;
			*pptr = ptr;
			if (result & e_reg2)
			{
				result &=~ e_workReg;
				int tmp = val & 0xF8;
				if (tmp == W0 || tmp == W8)
					result |= e_workReg;
			}
			if (val>1)
				result |= e_gt1;
			if (val<256)
				result |= e_lt256;
			if ((val&1)==0)
				result |= e_even;
			return (result &~ 0xFFFF) | val;
		}
	}
}

long ParseOperand(const char **pptr)
{
	long result = ParseOperand2(pptr);
	if (result)
	{
		for (;;)
		{
			const char *ptr = *pptr;
			char c = *ptr++;
			if (c!='+' && c!='-')
			{
				break;
			}
			long result2 = ParseOperand2(&ptr);
			if (result2 == 0 || (result & (e_indirect | e_index)) )
			{
				break;
			}
			long sum = result + result2;
			if ( c == '-' )
			{
				sum = result - result2;
			}
			long mask = 0xFFFF;
			if (result2 & e_reg)
			{
				mask = 0xFF;
			}
			result = (result &~ mask) + (sum & mask);
			*pptr = ptr;
		}
	}
	return result;
}

void ReadInstFile(char *name)
{
	char *TmpPtr = NULL;
	const char *ptr;
	int infile = _open(name, _O_BINARY | O_RDONLY);
	if (infile != -1)
	{
		int size = _filelength( infile );
		TmpPtr = new char[size+1];
		_read(infile, TmpPtr, size);
		_close(infile);
		TmpPtr[size] = 0;
	}
	else
	{
		int size1 = strlen(inst1);
		int size2 = strlen(inst2)+1;
		TmpPtr = new char[size1+size2];
		memcpy(TmpPtr, inst1, size1);
		memcpy(TmpPtr+size1, inst2, size2);
	}
	ptr = TmpPtr;
	int ndx=0;
	for (;;)
	{
		long inst = ParseHex(&ptr);
		if (inst >= 0)
		{
			Str str;
			if ( ParseName( &ptr, &str ) )
			{
				INST[ndx].value = inst;
				INST[ndx].opcode = NewString(str);
				INST[ndx].operand[0] = ParseTemplate(&ptr);
				INST[ndx].operand[1] = ParseTemplate(&ptr);
				INST[ndx].operand[2] = ParseTemplate(&ptr);
				ptr = SkipWhite(ptr);
				if (++ndx >= sizeof(INST)/sizeof(*INST))
					break;
			}
		}
		while (*ptr == '\r' || *ptr =='\n')
			++ptr;
		if (*ptr == 0)
			break;
	}
	endINST = INST+ndx;
	delete TmpPtr;
}

void assemble(FILE *infile)
{
	pc = 0;
	xpc = 0;
	epc = 0;
	while (fgets(buf, sizeof(buf), infile))
	{
		const char *ptr = buf;
		Str str;
		if ( ! ParseName( &ptr, &str ) )
			goto line_end;

		if (ptr[0] == ':')
		{
			NewLabel(pc, str);
			ptr++;
			if ( ! ParseName( &ptr, &str ) )
				goto line_end;
		}
		else if (ptr[0] == '=')
		{
			ptr++;
			int val = ParseOperand(&ptr);
			if (val==0)
			{
				NewLabel(e_lt256, str);
				goto error;
			}
			NewLabel(val, str);
			emitv(val);
			goto line_end;
		}


		if (cmpi(str,"ORG")==0)
		{
			int val = ParseOperand(&ptr);
			if (val==0)
				goto error;
			pc = val & 0xFFFF;
			emitv(val);
			goto line_end;
		}

		if (cmpi(str,"XORG")==0)
		{
			int val = ParseOperand(&ptr);
			if (val==0)
				goto error;
			xpc = val & 0xFFFF;
			emitv(val);
			goto line_end;
		}

		if (cmpi(str,"W0")==0)
		{
			int val = ParseOperand(&ptr);
			if (val==0)
				goto error;
			W0 = val & 0xFFFF;
			goto line_end;
		}

		if (cmpi(str,"W8")==0)
		{
			int val = ParseOperand(&ptr);
			if (val==0)
				goto error;
			W8 = val & 0xFFFF;
			goto line_end;
		}

		if (cmpi(str,"BYTE")==0 || cmpi(str,"DB")==0)
		{
			for (;;)
			{
				int byt = ParseOperand(&ptr);
				if (byt==0)
					goto line_end;
				emit(byt);
			}
		}
		if (cmpi(str,"WORD")==0 || cmpi(str,"DW")==0)
		{
			for (;;)
			{
				int wrd = ParseOperand(&ptr);
				if (wrd==0)
					goto line_end;
				emit(wrd>>8);
				emit(wrd);
			}
		}

		int op[3];
		op[0] = ParseOperand(&ptr);
		op[1] = ParseOperand(&ptr);
		op[2] = ParseOperand(&ptr);
		if (*ptr <= '\r')
			for (SINST *pI=INST; ; pI++)
			{
				if (pI >= endINST)
				{
					goto error;
				}
				if (cmpi(str, pI->opcode))
					continue;
				for (int n=0; n<3; n++)
				{
					long x = pI->operand[n];
					long y = x ^ op[n];
					if (y & e_match)
						break;
					if (y & x & e_match2)
						break;
				}
				if (n<3)
					continue;
				unsigned long val = pI->value;
				int bytes = 1;
				for (n = 0; n<3; n++)
				{
					int tm = pI->operand[n];
					if (tm==0)
						break;
					int pos = (tm>>16) & 3;
					int vv = op[n] & 0xFFFF;
					if (tm & e_bit)
					{
						val |= (op[n]>>7) & 0xE00;
						bytes |= 2;
					}
					if (tm & e_workReg)
					{
						static int shift[]={4,12,8};
						if (op[n] & e_reg2)
						{
							vv &= 7;
							if ( (op[n] & 0xF8) != W0 )
								vv |= 8;
						}
						val |= vv<<shift[pos];
						bytes |= pos+1;
					}
					else if (tm & e_lt256)
					{
						bytes |= 1<<(pos);
						val |= vv<<(8*pos);
					}
					else if (tm & e_relative)
					{
						bytes |= 1<<(pos);
						int offset = vv - (pc+pos+1);
						if (final && (offset < -128 || offset >127))
							printf("Branch out of range %04X: %s\n", pc, buf);
						val |= (offset&0xFF)<<(8*pos);
					}
					else
					{
						if (tm & e_msb)
						{
							vv = ((vv>>8)&0xFF) + ((vv&0xFF)<<8);
						}
						bytes |= 2<<(pos);
						val |= vv<<(8*pos);
					}
				}
				do
				{
					emit(val);
					val >>= 8;
				} while ( (bytes>>=1) != 0 );
				break;
			}
line_end:
		if (*ptr > '\r')
		{
error:
			if (final)
				printf("ERROR: %s", buf);
		}
		emiti(buf);
	}
}

void usage()
{
	printf("Usage S3C8ASM asm_file {-h Hexfile} {-a HexWithAddressfile} {-l ListFile}\n");
	exit(-1);
}

int main(int argc, char* argv[])
{
	int ln = strlen(argv[0]);
	char *name= new char[ln+5];
	strcpy(name, argv[0]);
	if (ln>4 && stricmp(name+ln-4, ".exe")==0)
		ln-=4;
	strcpy(name+ln, ".txt");
	ReadInstFile(name);
	if (argc < 2)
	{
		usage();
	}

	for (int pass=1; ; pass++)
	{
		NextFinal = 1;
		FILE *infile = fopen(argv[1],"r");
		if (!infile)
		{
			printf("Failed to open %s\n", argv[1]);
			exit(-1);
		}
		assemble(infile);
		fclose(infile);
		if (final)
			break;
		if (pass>=32 || NextFinal)
		{
			for (int arg=2; arg<argc;)
			{
				char *name = argv[arg++];
				int ndx;
				if (name[0] == '-')
				{
					static const char HAL[]="HAL";
					char *type = strchr(HAL, toupper(name[1]));
					ndx = type-HAL;
					if (type==NULL || outFile[ndx])
						usage();
					name += 2;
					if (*name==0)
					{
						if (arg==argc)
							usage();
						name = argv[arg++];
					}
				}
				else
					for (ndx=0; outFile[ndx]; ++ndx)
						if (ndx==3)
							usage();
				noFiles = 0;
				outFile[ndx] = fopen(name, "w");
				if (outFile[ndx]==NULL)
				{
					printf("Failed to create %s\n", name);
					exit(-1);
				}
			}
			final=1;
		}
	}
	for (int ndx=0; ndx<3; ndx++)
		if (outFile[ndx])
			fclose(outFile[ndx]);
	if (NextFinal==0)
		printf("Phase error: %s\n", PhaseError);
	return 0;
}

const char *inst1="\
12	ADC	W1,W2\n\
13	ADC	W1,@W2\n\
14	ADC	R2,R1\n\
15	ADC	R2,@R1\n\
16	ADC	R1,#2\n\
02	ADD	W1,W2\n\
03	ADD	W1,@W2\n\
04	ADD	R2,R1\n\
05	ADD	R2,@R1\n\
06	ADD	R1,#2\n\
52	AND	W1,W2\n\
53	AND	W1,@W2\n\
54	AND	R2,R1\n\
55	AND	R2,@R1\n\
56	AND	R1,#2\n\
067	BAND	W1,R2b\n\
167	BAND	R2b,W1\n\
017	BCP	W1,R2b\n\
057	BITC	W1b\n\
077	BITR	W1b\n\
177	BITS	W1b\n\
007	BOR	W1,R2b\n\
107	BOR	R2b,W1\n\
037	BTJRF	+2,W1b\n\
137	BTJRT	+2,W1b\n\
027	BXOR	W1,R2b\n\
127	BXOR	R2b,W1\n\
F6	CALL	A1\n\
F4	CALL	@RR1\n\
D4	CALL	@#e1\n\
EF	CCF\n\
B0	CLR	R1\n\
B1	CLR	@R1\n\
60	COM	R1\n\
61	COM	@R1\n\
A2	CP	W1,W2\n\
A3	CP	W1,@W2\n\
A4	CP	R2,R1\n\
A5	CP	R2,@R1\n\
A6	CP	R1,#2\n\
C2	CPIJE	W2,@W1,+2\n\
D2	CPIJNE	W2,@W1,+2\n\
40	DA	R1\n\
41	DA	@R1\n\
00	DEC	R1\n\
01	DEC	@R1\n\
80	DECW	RR1\n\
81	DECW	@R1\n\
8F	DI\n\
94	DIV	RR2,R1\n\
95	DIV	RR2,@R1\n\
96	DIV	RR2,#1\n\
A	DJNZ	W0,+1\n\
9F	EI\n\
1F	ENTER	A1\n\
1F	ENTER\n\
2F	EXIT\n\
6F	IDLE\n\
E	INC	W0\n\
20	INC	R1\n\
21	INC	@R1\n\
A0	INCW	RR1\n\
A1	INCW	@R1\n\
BF	IRET\n\
30	JP	@RR1\n\
8D	JP	A1\n\
0D	JPF	A1\n\
7D	JPC	A1\n\
FD	JPNC	A1\n\
6D	JPZ	A1\n\
ED	JPNZ	A1\n\
DD	JPPL	A1\n\
5D	JPMI	A1\n\
4D	JPOV	A1\n\
CD	JPNOV	A1\n\
6D	JPEQ	A1\n\
ED	JPNE	A1\n\
9D	JPGE	A1\n\
1D	JPLT	A1\n\
AD	JPGT	A1\n\
2D	JPLE	A1\n\
FD	JPUGE	A1\n\
7D	JPULT	A1\n\
BD	JPUGT	A1\n\
3D	JPULE	A1\n\
8B	JR	+1\n\
0B	JRF	+1\n\
7B	JRC	+1\n\
FB	JRNC	+1\n\
6B	JRZ	+1\n\
EB	JRNZ	+1\n\
DB	JRPL	+1\n\
5B	JRMI	+1\n\
4B	JROV	+1\n\
CB	JRNOV	+1\n\
6B	JREQ	+1\n\
EB	JRNE	+1\n\
9B	JRGE	+1\n\
1B	JRLT	+1\n\
AB	JRGT	+1\n\
2B	JRLE	+1\n\
FB	JRUGE	+1\n\
7B	JRULT	+1\n\
BB	JRUGT	+1\n\
3B	JRULE	+1\n\
C	LD	W0,#1\n\
8	LD	W0,R1\n\
9	LD	R1,W0\n\
C7	LD	W1,@W2\n\
D7	LD	@W1,W2\n\
E4	LD	R2,R1\n\
E5	LD	R2,@R1\n\
E6	LD	R1,#2\n\
D6	LD	@R1,#2\n\
F5	LD	@R2,R1\n\
87	LD	W1,R2[W2\n\
97	LD	R2[W2,W1\n\
047	LDB	W1,R2b\n\
147	LDB	R2b,W1\n\
0C3	LDC	W1,@WW2\n\
0D3	LDC	@WW2,W1\n\
0E7	LDC	W1,#2[WW2\n\
0F7	LDC	#2[WW2,W1\n\
0A7	LDC	W1,2[WW2>\n\
0B7	LDC	2[WW2>,W1\n\
0A7	LDC	W1,2\n\
0B7	LDC	2,W1\n\
1C3	LDE	W1,@WW2\n\
1D3	LDE	@WW2,W1\n\
1E7	LDE	W1,#2[WW2\n\
1F7	LDE	#2[WW2,W1\n\
1A7	LDE	W1,2[WW2>\n\
1B7	LDE	2[WW2>,W1\n\
1A7	LDE	W1,2\n\
1B7	LDE	2,W1\n\
0E2	LDCD	W1,@WW2\n\
1E2	LDED	W1,@WW2\n\
0E3	LDCI	W1,@WW2\n\
1E3	LDEI	W1,@WW2\n\
0F2	LDCPD	@WW2,W1\n\
1F2	LDEPD	@WW2,w1\n\
0F3	LDCPI	@WW2,W1\n\
1F3	LDEPI	@WW2,W1\n\
C4	LDW	RR2,RR1\n\
C5	LDW	RR2,@R1\n\
C6	LDW	RR1,A2\n\
84	MULT	RR2,R1\n\
85	MULT	RR2,@R1\n\
86	MULT	RR2,#1\n\
0F	NEXT\n\
FF	NOP\n\
42	OR	W1,W2\n\
43	OR	W1,@W2\n\
44	OR	R2,R1\n\
45	OR	R2,@R1\n\
46	OR	R1,#2\n\
50	POP	R1\n\
51	POP	@R1\n\
92	POPUD	R2,@R1\n\
";
const char *inst2="\
93	POPUI	R2,@R1\n\
70	PUSH	R1\n\
71	PUSH	@R1\n\
82	PUSHUD	@R1,R2\n\
83	PUSHUI	@R1,R2\n\
CF	RCF\n\
AF	RET\n\
90	RL	R1\n\
91	RL	@R1\n\
10	RLC	R1\n\
11	RLC	@R1\n\
E0	RR	R1\n\
E1	RR	@R1\n\
C0	RRC	R1\n\
C1	RRC	@R1\n\
4F	SB0\n\
5F	SB1\n\
32	SBC	W1,W2\n\
33	SBC	W1,@W2\n\
34	SBC	R2,R1\n\
35	SBC	R2,@R1\n\
36	SBC	R1,#2\n\
DF	SCF\n\
D0	SRA	R1\n\
D1	SRA	@R1\n\
031	SRP	#1e\n\
231	SRP0	#1e\n\
131	SRP1	#1e\n\
7F	STOP\n\
22	SUB	W1,W2\n\
23	SUB	W1,@W2\n\
24	SUB	R2,R1\n\
25	SUB	R2,@R1\n\
26	SUB	R1,#2\n\
F0	SWAP	R1\n\
F1	SWAP	@R1\n\
62	TCM	W1,W2\n\
63	TCM	W1,@W2\n\
64	TCM	R2,R1\n\
65	TCM	R2,@R1\n\
66	TCM	R1,#2\n\
72	TM	W1,W2\n\
73	TM	W1,@W2\n\
74	TM	R2,R1\n\
75	TM	R2,@R1\n\
76	TM	R1,#2\n\
3F	WFI\n\
B2	XOR	W1,W2\n\
B3	XOR	W1,@W2\n\
B4	XOR	R2,R1\n\
B5	XOR	R2,@R1\n\
B6	XOR	R1,#2\n\
";